<?php
/**
 * Template Name: Home Custom Page
 */
?>

<?php get_header(); ?>

<main id="main" role="main">
  <?php do_action( 'roofing_solutions_above_slider' ); ?>

  <?php if( get_theme_mod('roofing_solutions_slider_hide_show', false) != ''){ ?> 

    <section id="slider" class="m-0 p-0 mw-100">
      <div id="carouselExampleCaptions" class="carousel slide" data-bs-ride="carousel"> 
        <?php $roofing_solutions_content_pages = array();
          for ( $count = 1; $count <= 4; $count++ ) {
            $mod = intval( get_theme_mod( 'roofing_solutions_slider_page' . $count ));
            if ( 'page-none-selected' != $mod ) {
              $roofing_solutions_content_pages[] = $mod;
            }
          }
          if( !empty($roofing_solutions_content_pages) ) :
            $args = array(
              'post_type' => 'page',
              'post__in' => $roofing_solutions_content_pages,
              'orderby' => 'post__in'
            );
            $query = new WP_Query( $args );
          if ( $query->have_posts() ) :
            $i = 1;
        ?>     
        <div class="carousel-inner" role="listbox">
          <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
            <div <?php if($i == 1){echo 'class="carousel-item active"';} else{ echo 'class="carousel-item"';}?>>             
              <div class="sliderbg-img">
                  <?php the_post_thumbnail(); ?>
                  <div class="slide-oly"></div>
              </div>
              <?php
                $roofing_solutions_slider_animation = get_theme_mod('roofing_solutions_slider_animation', '')
                ?>
              <div class="slider-content <?php echo($roofing_solutions_slider_animation)?>">
                  <div class="inner_carousel">
                    <h1><?php the_title(); ?></h1>
                    <p>
                      <?php $roofing_solutions_excerpt = get_the_excerpt(); echo esc_html( roofing_solutions_string_limit_words( $roofing_solutions_excerpt,20 ) ); ?>
                    </p>
                    <div class="read-btn">
                      <a href="<?php echo esc_url(get_permalink()); ?>"><span><?php esc_html_e( 'View More', 'roofing-solutions' ); ?></span><span class="screen-reader-text"><?php esc_html_e( 'View More', 'roofing-solutions' );?></span></a>
                    </div>
                  </div>
                
              </div>
            </div>
          <?php $i++; endwhile; 
          wp_reset_postdata();?>

           
        </div>
        <?php else : ?>
          <div class="no-postfound"></div>
        <?php endif;
        endif;?>
        <a class="carousel-control-prev" data-bs-target="#carouselExampleCaptions" data-bs-slide="prev" role="button">
          <span class="carousel-control-prev-icon" aria-hidden="true"><i class="fas fa-caret-left"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Previous', 'roofing-solutions' );?></span>
        </a>
        <a class="carousel-control-next" data-bs-target="#carouselExampleCaptions" data-bs-slide="next" role="button">
          <span class="carousel-control-next-icon" aria-hidden="true"><i class="fas fa-caret-right"></i></span><span class="screen-reader-text"><?php esc_html_e( 'Next', 'roofing-solutions' );?></span>
        </a>
      </div>   
      <div class="clearfix"></div>
    </section>
  <?php }?>

  <?php do_action( 'roofing_solutions_below_slider' ); ?>

    <section id="feature" class="m-0 p-0 mw-100">
        <div class="featurebx">
            <div id="feature-con" class="container"> 
              <?php $roofing_solutions_content_pages_feature = array();
                for ( $count = 1; $count <= 4; $count++ ) {
                  $mod = intval( get_theme_mod( 'roofing_solutions_feature_page' . $count ));
                  if ( 'page-none-selected' != $mod ) {
                    $roofing_solutions_content_pages_feature[] = $mod;
                  }
                }
                if( !empty($roofing_solutions_content_pages_feature) ) :
                  $args = array(
                    'post_type' => 'page',
                    'post__in' => $roofing_solutions_content_pages_feature,
                    'orderby' => 'post__in'
                  );
                  $query = new WP_Query( $args );
                if ( $query->have_posts() ) :
                  $i = 1;
              ?>     

              <div class="row mr-0">
                <?php  while ( $query->have_posts() ) : $query->the_post(); ?>
                  <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 feabx">
                      <div class="feabxinn">  
                          <div class="single-fea">
                              <div class="icnbx">         
                                  <i class="fas fa-home"></i>
                              </div>  
                              <div class="imagebx">
                                  <?php the_post_thumbnail(); ?>
                              </div>
                              <div class="content">
                                    <h1><?php the_title(); ?></h1>
                                    <p>
                                      <?php $roofing_solutions_excerpt = get_the_excerpt(); echo esc_html( roofing_solutions_string_limit_words( $roofing_solutions_excerpt,20 ) ); ?>
                                    </p>
                              </div>
                            </div>
                      </div>
                  </div>
                <?php $i++; endwhile; 
                wp_reset_postdata();?>
              </div>
              <?php else : ?>
                <div class="no-postfound"></div>
              <?php endif;
              endif;?>
            </div>   
        </div>
        <div class="clearfix"></div>
    </section>

  <?php if( get_theme_mod('roofing_solutions_service_category') != ''){ ?>

    <section id="service-section" >
      <div class="container">
        <?php if(get_theme_mod('roofing_solutions_btn_serviceheading') != ''){ ?>
          <div class="service-head">
              <h4>
                  <svg xmlns="http://www.w3.org/2000/svg" width="310" height="41" viewBox="0 0 310 41">
                  <g id="heading" transform="translate(-155.308 -1720)">
                    <path id="Path_10" data-name="Path 10" d="M130.226,39.877,84.562,0,54.684,26.959,35.516,8.986,0,39.877,10.711,41,34.952,20.219,59.194,41l9.584-1.123-9.02-8.425,24.8-20.781,34.389,29.205Z" transform="translate(245.774 1720)" fill="" fill-rule="evenodd"></path>
                    <path id="Path_11" data-name="Path 11" d="M91,0H0V6.5H86.125Z" transform="translate(155.308 1753.5)" fill="" fill-rule="evenodd"></path>
                    <path id="Path_12" data-name="Path 12" d="M0,0H91V6.5H4.875Z" transform="translate(374.308 1753.5)" fill="" fill-rule="evenodd"></path>
                  </g>
                </svg>
                <?php echo esc_html(get_theme_mod('roofing_solutions_btn_serviceheading')); ?>
                  
            </h4>
          </div>
        <?php }?>

        <div class="row mr-0">
          <?php $roofing_solutions_catData =  get_theme_mod('roofing_solutions_service_category');
          if($roofing_solutions_catData){
            $page_query = new WP_Query(array( 'category_name' => esc_html($roofing_solutions_catData,'roofing-solutions'))); ?>
            <?php while( $page_query->have_posts() ) : $page_query->the_post(); ?>  
              
              <div class="col-lg-4 col-md-6 col-sm-6  serbx ">
                <div class="service-box text-center ">
                  <div class="service-img">
                    <?php the_post_thumbnail(); ?>

                   <!--  <svg class="boxsvgshape" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 388 90">
                          <path fill-rule="evenodd" d="M391.011,8.780 C387.986,33.461 369.757,53.596 345.778,59.039 C321.243,64.608 295.568,53.691 282.452,31.899 C272.537,42.469 258.817,48.771 244.256,48.987 C227.286,49.239 211.360,41.209 201.034,27.879 C190.383,52.565 167.017,69.195 140.724,71.101 C115.898,72.900 91.871,61.358 77.398,40.946 C62.045,45.571 45.484,44.157 31.160,36.925 C16.392,29.469 5.203,16.435 0.000,0.739 C0.000,34.580 0.000,68.420 0.000,102.261 C130.002,102.261 260.004,102.261 390.005,102.261 C390.341,71.101 390.676,39.941 391.011,8.780 Z"></path>
                      </svg> -->
                      <div class="clearfix"></div>
                  </div>
                  <div class="service-content">

                    <div class="icon">
                      <i class="fa fa-home" aria-hidden="true"></i>
                    </div>

                    <a href="<?php echo esc_url( get_permalink() );?>">
                        <div class="title"><?php the_title();?></div>
                    </a>

                    <p>
                      <?php $roofing_solutions_excerpt = get_the_excerpt(); echo esc_html( roofing_solutions_string_limit_words( $roofing_solutions_excerpt,20 ) ); ?> 
                    </p>
                    <div class="button"><a href="<?php the_permalink(); ?>"><span><?php echo esc_html('Read More', 'roofing-solutions'); ?></span></a></div>
                  </div>
                </div>
                <div class="clearfix"></div>
              </div>
              <!-- </div> -->
            <?php endwhile; 
            wp_reset_postdata();
          } ?>
        </div>
      </div>
      <div class="clearfix"></div>
    </section>
  <?php }?>
  <?php do_action( 'roofing_solutions_below_best_sellers' ); ?>

  <div class="container entry-content py-4">
    <?php while ( have_posts() ) : the_post(); ?>
      <?php the_content(); ?>
    <?php endwhile; // end of the loop. ?>
  </div>
</main>
<?php get_footer(); ?>